/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.switchButton;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class SwitchButton
extends Canvas {
    private boolean selection = false;
    private String textForSelect = "On";
    private String textForUnselect = "Off";
    private String text;
    private boolean round = true;
    private Color borderColor = null;
    private Color focusColor = this.getDisplay().getSystemColor(7);
    private Color selectedForegroundColor = this.getDisplay().getSystemColor(1);
    private Color selectedBackgroundColor = SWTGraphicUtil.getDefaultColor((Control)this, 0, 112, 195);
    private Color unselectedForegroundColor = this.getDisplay().getSystemColor(2);
    private Color unselectedBackgroundColor = SWTGraphicUtil.getDefaultColor((Control)this, 203, 203, 203);
    private Color buttonBorderColor = SWTGraphicUtil.getDefaultColor((Control)this, 96, 96, 96);
    private Color buttonBackgroundColor1 = SWTGraphicUtil.getDefaultColor((Control)this, 254, 254, 254);
    private Color buttonBackgroundColor2 = SWTGraphicUtil.getDefaultColor((Control)this, 192, 192, 192);
    private int gap = 5;
    private static final int INSIDE_BUTTON_MARGIN = 5;
    private GC gc;
    private final List<SelectionListener> listOfSelectionListeners = new ArrayList<SelectionListener>();
    private boolean mouseInside;

    public SwitchButton(Composite composite, int n) {
        super(composite, n | 0x20000000);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                SwitchButton.this.onPaint(paintEvent);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (SwitchButton.this.fireSelectionListeners(mouseEvent)) {
                    SwitchButton.this.selection = !SwitchButton.this.selection;
                    SwitchButton.this.redraw();
                }
            }
        });
        this.mouseInside = false;
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent mouseEvent) {
                SwitchButton.this.mouseInside = true;
                SwitchButton.this.redraw();
            }

            public void mouseExit(MouseEvent mouseEvent) {
                SwitchButton.this.mouseInside = false;
                SwitchButton.this.redraw();
            }

            public void mouseEnter(MouseEvent mouseEvent) {
                SwitchButton.this.mouseInside = true;
                SwitchButton.this.redraw();
            }
        });
    }

    private void onPaint(PaintEvent paintEvent) {
        Rectangle rectangle = this.getClientArea();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        this.gc = paintEvent.gc;
        this.gc.setAntialias(1);
        Point point = this.computeButtonSize();
        this.drawSwitchButton(point);
        this.drawText(point);
        if (this.borderColor != null) {
            this.drawBorder();
        }
    }

    private void drawSwitchButton(Point point) {
        this.gc.setForeground(this.buttonBorderColor);
        if (this.round) {
            this.gc.drawRoundRectangle(2, 2, point.x, point.y, 3, 3);
        } else {
            this.gc.drawRectangle(2, 2, point.x, point.y);
        }
        this.drawRightPart(point);
        this.drawLeftPart(point);
        this.gc.setClipping(this.getClientArea());
        this.drawToggleButton(point);
    }

    private void drawRightPart(Point point) {
        this.gc.setForeground(this.selectedBackgroundColor);
        this.gc.setBackground(this.selectedBackgroundColor);
        this.gc.setClipping(3, 3, point.x / 2, point.y - 1);
        if (this.round) {
            this.gc.fillRoundRectangle(2, 2, point.x, point.y, 3, 3);
        } else {
            this.gc.fillRectangle(2, 2, point.x, point.y);
        }
        this.gc.setForeground(this.selectedForegroundColor);
        Point point2 = this.gc.textExtent(this.textForSelect);
        this.gc.drawString(this.textForSelect, (point.x / 2 - point2.x) / 2 + 3, (point.y - point2.y) / 2 + 3);
    }

    private void drawLeftPart(Point point) {
        this.gc.setForeground(this.unselectedBackgroundColor);
        this.gc.setBackground(this.unselectedBackgroundColor);
        this.gc.setClipping(point.x / 2 + 3, 3, point.x / 2, point.y - 1);
        if (this.round) {
            this.gc.fillRoundRectangle(2, 2, point.x, point.y, 3, 3);
        } else {
            this.gc.fillRectangle(2, 2, point.x, point.y);
        }
        this.gc.setForeground(this.unselectedForegroundColor);
        Point point2 = this.gc.textExtent(this.textForUnselect);
        this.gc.drawString(this.textForUnselect, point.x / 2 + (point.x / 2 - point2.x) / 2 + 3, (point.y - point2.y) / 2 + 3);
    }

    private void drawToggleButton(Point point) {
        this.gc.setForeground(this.buttonBackgroundColor1);
        this.gc.setBackground(this.buttonBackgroundColor2);
        if (this.selection) {
            this.gc.fillGradientRectangle(3, 3, point.x / 2, point.y, true);
        } else {
            this.gc.fillGradientRectangle(point.x / 2, 3, point.x / 2 + 2, point.y - 1, true);
        }
        this.gc.setForeground(this.buttonBorderColor);
        if (this.selection) {
            this.gc.drawRoundRectangle(2, 2, point.x / 2, point.y, 3, 3);
        } else {
            this.gc.drawRoundRectangle(point.x / 2, 2, point.x / 2 + 2, point.y, 3, 3);
        }
        if (this.focusColor != null && this.mouseInside) {
            this.gc.setForeground(this.focusColor);
            this.gc.setLineWidth(2);
            if (this.selection) {
                this.gc.drawRoundRectangle(3, 3, point.x / 2, point.y - 1, 3, 3);
            } else {
                this.gc.drawRoundRectangle(point.x / 2 + 1, 3, point.x / 2, point.y - 2, 3, 3);
            }
            this.gc.setLineWidth(1);
        }
    }

    private Point computeButtonSize() {
        Point point = this.gc.stringExtent(this.textForSelect);
        Point point2 = this.gc.stringExtent(this.textForUnselect);
        int n = Math.max(point.x, point2.x) * 2 + 10;
        int n2 = Math.max(point.y, point2.y) + 10;
        return new Point(n, n2);
    }

    private void drawText(Point point) {
        this.gc.setForeground(this.getForeground());
        this.gc.setBackground(this.getBackground());
        int n = this.computeSize((int)0, (int)0, (boolean)true).y;
        int n2 = this.gc.stringExtent((String)this.text).y;
        int n3 = 2 + point.x + this.gap;
        this.gc.drawString(this.text, n3, (n - n2) / 2);
    }

    private void drawBorder() {
        if (this.borderColor == null) {
            return;
        }
        this.gc.setForeground(this.borderColor);
        Point point = this.computeSize(0, 0, false);
        if (this.round) {
            this.gc.drawRoundRectangle(0, 0, point.x - 2, point.y - 2, 3, 3);
        } else {
            this.gc.drawRectangle(0, 0, point.x - 2, point.y - 2);
        }
    }

    private boolean fireSelectionListeners(MouseEvent mouseEvent) {
        for (SelectionListener selectionListener : this.listOfSelectionListeners) {
            Event event = new Event();
            event.button = mouseEvent.button;
            event.display = this.getDisplay();
            event.item = null;
            event.widget = this;
            event.data = null;
            event.time = mouseEvent.time;
            event.x = mouseEvent.x;
            event.y = mouseEvent.y;
            SelectionEvent selectionEvent = new SelectionEvent(event);
            selectionListener.widgetSelected(selectionEvent);
            if (selectionEvent.doit) continue;
            return false;
        }
        return true;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        this.listOfSelectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error((int)4);
        }
        this.listOfSelectionListeners.remove(selectionListener);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        boolean bl2 = false;
        if (this.gc == null || this.gc.isDisposed()) {
            this.gc = new GC((Drawable)this);
            bl2 = true;
        }
        Point point = this.computeButtonSize();
        int n3 = point.x;
        int n4 = point.y;
        if (this.text != null && this.text.trim().length() > 0) {
            Point point2 = this.gc.textExtent(this.text);
            n3 += point2.x + this.gap + 1;
        }
        n3 += 4;
        n4 += 6;
        if (bl2) {
            this.gc.dispose();
        }
        return new Point(n3, n4);
    }

    public boolean getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        this.selection = bl;
    }

    public String getTextForSelect() {
        this.checkWidget();
        return this.textForSelect;
    }

    public void setTextForSelect(String string) {
        this.checkWidget();
        this.textForSelect = string;
    }

    public String getTextForUnselect() {
        this.checkWidget();
        return this.textForUnselect;
    }

    public void setTextForUnselect(String string) {
        this.checkWidget();
        this.textForUnselect = string;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public void setText(String string) {
        this.checkWidget();
        this.text = string;
    }

    public boolean isRound() {
        this.checkWidget();
        return this.round;
    }

    public void setRound(boolean bl) {
        this.checkWidget();
        this.round = bl;
    }

    public Color getBorderColor() {
        this.checkWidget();
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.checkWidget();
        this.borderColor = color;
    }

    public Color getFocusColor() {
        this.checkWidget();
        return this.focusColor;
    }

    public void setFocusColor(Color color) {
        this.checkWidget();
        this.focusColor = color;
    }

    public Color getSelectedForegroundColor() {
        this.checkWidget();
        return this.selectedForegroundColor;
    }

    public void setSelectedForegroundColor(Color color) {
        this.checkWidget();
        this.selectedForegroundColor = color;
    }

    public Color getSelectedBackgroundColor() {
        this.checkWidget();
        return this.selectedBackgroundColor;
    }

    public void setSelectedBackgroundColor(Color color) {
        this.checkWidget();
        this.selectedBackgroundColor = color;
    }

    public Color getUnselectedForegroundColor() {
        this.checkWidget();
        return this.unselectedForegroundColor;
    }

    public void setUnselectedForegroundColor(Color color) {
        this.checkWidget();
        this.unselectedForegroundColor = color;
    }

    public Color getUnselectedBackgroundColor() {
        this.checkWidget();
        return this.unselectedBackgroundColor;
    }

    public void setUnselectedBackgroundColor(Color color) {
        this.checkWidget();
        this.unselectedBackgroundColor = color;
    }

    public Color getButtonBorderColor() {
        this.checkWidget();
        return this.buttonBorderColor;
    }

    public void setButtonBorderColor(Color color) {
        this.checkWidget();
        this.buttonBorderColor = color;
    }

    public Color getButtonBackgroundColor1() {
        this.checkWidget();
        return this.buttonBackgroundColor1;
    }

    public void setButtonBackgroundColor1(Color color) {
        this.checkWidget();
        this.buttonBackgroundColor1 = color;
    }

    public Color getButtonBackgroundColor2() {
        this.checkWidget();
        return this.buttonBackgroundColor2;
    }

    public void setButtonBackgroundColor2(Color color) {
        this.checkWidget();
        this.buttonBackgroundColor2 = color;
    }

    public int getGap() {
        this.checkWidget();
        return this.gap;
    }

    public void setGap(int n) {
        this.checkWidget();
        this.gap = n;
    }
}

