/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.systemMonitor;

import java.util.List;
import org.eclipse.swt.graphics.RGB;
import org.mihalis.opal.systemMonitor.Sample;
import org.mihalis.opal.utils.FixedSizeQueue;

public class SampleWrapper {
    private RGB color;
    private RGB borderColor;
    private String caption;
    private String formatPattern;
    private final Sample sample;
    private final FixedSizeQueue<Double> data;
    private Double lastValue;
    private Double lastMaxValue;
    private Double maxValue;

    SampleWrapper(Sample sample) {
        this.sample = sample;
        this.color = new RGB(255, 255, 216);
        this.caption = "";
        this.formatPattern = "";
        this.data = new FixedSizeQueue(1000);
        this.lastValue = 0.0;
        this.lastMaxValue = 0.0;
        this.maxValue = 0.0;
        this.createBorderColor();
    }

    private void createBorderColor() {
        this.borderColor = new RGB(Math.min(this.color.red * 2, 255), Math.min(this.color.green * 2, 255), Math.min(this.color.blue * 2, 255));
    }

    void collect() {
        this.lastValue = this.sample.getValue();
        this.maxValue = Math.max(this.lastMaxValue, this.sample.getMaxValue());
        this.lastMaxValue = this.sample.getMaxValue();
        this.data.put(this.lastValue);
    }

    public RGB getBorderColor() {
        return this.borderColor;
    }

    public String getCaption() {
        return this.caption;
    }

    RGB getColor() {
        return this.color;
    }

    public List<Double> getData() {
        return this.data.getValues();
    }

    String getFormatPattern() {
        return this.formatPattern;
    }

    public Double getLastMaxValue() {
        return this.lastMaxValue;
    }

    public Double getLastValue() {
        return this.lastValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public int getNumberOfCollectedElements() {
        return this.data.getSize();
    }

    Sample getSample() {
        return this.sample;
    }

    public void resize(int n) {
        this.data.resizeTo(n);
    }

    SampleWrapper setCaption(String string) {
        this.caption = string;
        return this;
    }

    SampleWrapper setColor(RGB rGB) {
        this.color = rGB;
        this.createBorderColor();
        return this;
    }

    SampleWrapper setFormatPattern(String string) {
        this.formatPattern = string;
        return this;
    }
}

