/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.dialogs.discountsystem;

import java.math.BigDecimal;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.cashserver.security.SecurityKey;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.dialogs.SystemTitleAreaDialog;
import su.artix.discountmanager.dialogs.discountsystem.DiscountRateConstructorDialog;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.discountmanager.images.ImagesFactory;
import su.artix.discountmanager.utils.ErrorMessageFactory;
import su.artix.discountmanager.utils.QuestionMessageFactory;
import su.artix.discountmanager.views.PeriodicImpactsBonusSystemView;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateCalculate;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateIndex;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRatePercent;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRatePrice;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountRateSum;
import su.artix.loyaltylib.domain.java.observable.Named;
import su.artix.yuki.editors.DialogMode;

@SecurityKey(title="\u0421\u0442\u0430\u0432\u043a\u0438")
public class DiscountRateDialog
extends SystemTitleAreaDialog {
    private static final Logger log = LoggerFactory.getLogger(DiscountRateDialog.class);
    private Discount discount;
    private DiscountRate discountRate;
    @SecurityKey(title="\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", id="value")
    private Label valueLabel;
    @SecurityKey(id="value")
    private Spinner percentValSpinner;
    @SecurityKey(id="value")
    private Text calcValField = null;
    @SecurityKey(id="value")
    private Spinner sumValSpinner;
    @SecurityKey(id="value")
    private Spinner indexValField = null;
    @SecurityKey(title="\u0422\u0438\u043f", id="type")
    private Label typeLabel;
    @SecurityKey(id="type")
    private Combo typeCombo;
    private int percentDigit = 1;
    private int sumValDigit = 2;
    private int sumValMaxValue = 1000000;
    private boolean confirmCancel;

    public DiscountRateDialog(Discount discount, DiscountRate discountRate, Map<String, String> paramList, DialogMode dialogMode) {
        super(Display.getCurrent().getActiveShell(), dialogMode, paramList);
        this.discount = discount;
        this.discountRate = discountRate;
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        this.confirmCancel = preferenceStore.getBoolean("CONFIRM_CANCEL_FOR_COMPLEX_DIALOG");
    }

    @Override
    protected Control createContents(Composite parentComposite) {
        Control content = super.createContents(parentComposite);
        this.fillTitleHeader((Named)this.discount, (Named)this.discountRate);
        return content;
    }

    @Override
    protected void fillTitleHeader(Named parent, Named current) {
        log.debug("params:{}", (Object)this.paramList);
        this.setTitleDialog((String)this.paramList.get("title"));
        this.setMessage("\u0421\u0442\u0430\u0432\u043a\u0430");
    }

    @Override
    protected boolean isResizable() {
        return true;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite((Composite)super.createDialogArea(parent), 0);
        GridLayoutFactory.swtDefaults().spacing(5, 5).numColumns(3).applyTo(container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        this.valueLabel = new Label(container, 0);
        this.valueLabel.setText("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.valueLabel);
        if (this.discountRate instanceof DiscountRatePercent) {
            log.trace("Start dialog in percent mode");
            this.percentValSpinner = new Spinner(container, 2048);
            GridDataFactory.fillDefaults().span(3, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.percentValSpinner);
            this.percentValSpinner.setDigits(this.percentDigit);
            this.percentValSpinner.setIncrement((int)Math.pow(10.0, this.percentValSpinner.getDigits()));
            this.percentValSpinner.setPageIncrement((int)Math.pow(10.0, this.percentValSpinner.getDigits() + 1));
            this.percentValSpinner.setMaximum(1000);
            this.percentValSpinner.setMinimum(0);
            if (this.getDiscountRate() != null && this.getDiscountRate().getDiscountValue() != null) {
                this.percentValSpinner.setSelection(((DiscountRatePercent)this.discountRate).getDiscountValue().unscaledValue().intValue());
            }
        } else if (this.discountRate instanceof DiscountRateCalculate) {
            log.trace("Start dialog in calculate rate mode");
            this.valueLabel.setText("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u043e\u0439 \u0441\u0442\u0430\u0432\u043a\u0438:");
            this.calcValField = new Text(container, 128);
            GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.calcValField);
            Button btn = new Button(container, 8);
            btn.setToolTipText("\u041f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440\u0430");
            btn.setImage(ImagesFactory.INSTANCE.getImage("16x16/shadow/construction.png"));
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DiscountRateConstructorDialog dialog = new DiscountRateConstructorDialog("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u0440\u0430\u0441\u0447\u0435\u0442\u043d\u043e\u0439 \u0441\u0442\u0430\u0432\u043a\u0438");
                    if (dialog.open() == 0) {
                        log.info("Return from rate constructor: {}", (Object)dialog.getDiscountCondition());
                        DiscountRateDialog.this.calcValField.setText(dialog.getDiscountCondition());
                    }
                }
            });
            this.typeLabel = new Label(container, 0);
            GridDataFactory.fillDefaults().applyTo((Control)this.typeLabel);
            this.typeLabel.setText("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0441\u0442\u0430\u0432\u043a\u0438");
            this.typeCombo = new Combo(container, 2056);
            GridDataFactory.fillDefaults().span(2, 1).align(16384, 4).grab(true, false).applyTo((Control)this.typeCombo);
            this.typeCombo.add("\u0421\u0443\u043c\u043c\u0430");
            if (!(ViewHolder.INSTANCE.getActiveViewPart() instanceof PeriodicImpactsBonusSystemView)) {
                this.typeCombo.add("\u041f\u0440\u043e\u0446\u0435\u043d\u0442\u044b");
                this.typeCombo.add("\u0418\u043d\u0434\u0435\u043a\u0441\u044b");
                this.typeCombo.add("\u0424\u0438\u043a\u0441. \u0446\u0435\u043d\u0430");
                this.typeCombo.select(1);
            } else {
                this.typeCombo.select(0);
            }
            if (this.getDiscountRate() != null && this.getDiscountRate().getDiscountValue() != null) {
                DiscountRateCalculate calculateRate = (DiscountRateCalculate)this.discountRate;
                this.calcValField.setText(calculateRate.getDiscountValue());
                if (calculateRate.getDiscountRateType().equals("sum")) {
                    this.typeCombo.select(0);
                } else if (calculateRate.getDiscountRateType().equals("percent")) {
                    this.typeCombo.select(1);
                } else if (calculateRate.getDiscountRateType().equals("index")) {
                    this.typeCombo.select(2);
                } else if (calculateRate.getDiscountRateType().equals("price")) {
                    this.typeCombo.select(3);
                }
            }
        } else if (this.discountRate instanceof DiscountRateSum) {
            log.trace("Start dialog in sum mode");
            this.sumValSpinner = new Spinner(container, 2048);
            GridDataFactory.fillDefaults().span(3, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.sumValSpinner);
            this.sumValSpinner.setDigits(this.sumValDigit);
            this.sumValSpinner.setIncrement((int)Math.pow(10.0, this.sumValSpinner.getDigits()));
            this.sumValSpinner.setPageIncrement((int)Math.pow(10.0, this.sumValSpinner.getDigits() + 1));
            this.sumValSpinner.setMinimum(0);
            this.sumValSpinner.setMaximum(this.sumValMaxValue);
            if (this.getDiscountRate() != null && this.getDiscountRate().getDiscountValue() != null) {
                this.sumValSpinner.setSelection(((DiscountRateSum)this.discountRate).getDiscountValue().unscaledValue().intValue());
            }
        } else if (this.discountRate instanceof DiscountRateIndex) {
            log.trace("Start dialog in index rate mode");
            this.indexValField = new Spinner(container, 2048);
            GridDataFactory.fillDefaults().span(3, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.indexValField);
            this.indexValField.setMaximum(Integer.MAX_VALUE);
            this.indexValField.setMinimum(Integer.MIN_VALUE);
            if (this.getDiscountRate() != null && this.getDiscountRate().getDiscountValue() != null) {
                this.indexValField.setSelection(((DiscountRateIndex)this.discountRate).getDiscountValue().intValue());
            }
        } else if (this.discountRate instanceof DiscountRatePrice) {
            log.trace("Start dialog in sum mode");
            this.sumValSpinner = new Spinner(container, 2048);
            GridDataFactory.fillDefaults().span(3, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.sumValSpinner);
            this.sumValSpinner.setDigits(this.sumValDigit);
            this.sumValSpinner.setIncrement((int)Math.pow(10.0, this.sumValSpinner.getDigits()));
            this.sumValSpinner.setPageIncrement((int)Math.pow(10.0, this.sumValSpinner.getDigits() + 1));
            this.sumValSpinner.setMinimum(0);
            this.sumValSpinner.setMaximum(this.sumValMaxValue * 1000);
            if (this.getDiscountRate() != null && this.getDiscountRate().getDiscountValue() != null) {
                this.sumValSpinner.setSelection(((DiscountRatePrice)this.discountRate).getDiscountValue().unscaledValue().intValue());
            }
        }
        return container;
    }

    protected void okPressed() {
        if (this.percentValSpinner != null) {
            this.discountRate.setDiscountValue((Object)BigDecimal.valueOf(this.percentValSpinner.getSelection(), this.percentDigit));
            super.okPressed();
        } else if (this.calcValField != null) {
            if (!this.calcValField.getText().equals("")) {
                this.discountRate.setDiscountValue((Object)this.calcValField.getText());
                switch (this.typeCombo.getSelectionIndex()) {
                    case 0: {
                        this.discountRate.setDiscountRateType("sum");
                        break;
                    }
                    case 1: {
                        this.discountRate.setDiscountRateType("percent");
                        break;
                    }
                    case 2: {
                        this.discountRate.setDiscountRateType("index");
                        break;
                    }
                    case 3: {
                        this.discountRate.setDiscountRateType("price");
                    }
                }
                super.okPressed();
            } else {
                ErrorMessageFactory.emptyFieldMessage();
            }
        } else if (this.sumValSpinner != null) {
            this.discountRate.setDiscountValue((Object)BigDecimal.valueOf(this.sumValSpinner.getSelection(), this.sumValDigit));
            super.okPressed();
        } else if (this.indexValField != null) {
            this.discountRate.setDiscountValue((Object)this.indexValField.getSelection());
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        if (this.confirmCancel && this.calcValField != null) {
            if (this.discount.getDiscountRate() instanceof DiscountRateCalculate) {
                if (!((DiscountRateCalculate)this.discount.getDiscountRate()).getDiscountValue().equals(this.calcValField.getText())) {
                    if (QuestionMessageFactory.cancelQuestionMessage()) {
                        super.cancelPressed();
                    }
                } else {
                    super.cancelPressed();
                }
            } else if (!this.calcValField.getText().isEmpty()) {
                if (QuestionMessageFactory.cancelQuestionMessage()) {
                    super.cancelPressed();
                }
            } else {
                super.cancelPressed();
            }
        } else {
            super.cancelPressed();
        }
    }

    public void setDiscountRate(DiscountRate discountRate) {
        this.discountRate = discountRate;
    }

    public DiscountRate getDiscountRate() {
        return this.discountRate;
    }
}

