/*
 * Decompiled with CFR 0.152.
 */
package su.artix.discountmanager.handlers.discountsystem;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.artix.discountmanager.Activator;
import su.artix.discountmanager.dialogs.discountsystem.DiscountConditionTemplateDialog;
import su.artix.discountmanager.holders.ViewHolder;
import su.artix.loyaltylib.domain.java.discountsystem.Discount;
import su.artix.loyaltylib.domain.java.discountsystem.DiscountCondition;
import su.artix.yuki.discount.condition.constructor.dao.ConstructorTreeProcessor;
import su.artix.yuki.discount.condition.template.dao.ConditionTemplateDAO;

public class AddTemplateConditionHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(AddTemplateConditionHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        DiscountCondition condition;
        Discount parent = (Discount)ViewHolder.INSTANCE.getSelectionElementFromActiveView();
        String title = null;
        try {
            title = event.getCommand().getName();
        }
        catch (NotDefinedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        ConditionTemplateDAO dao = Activator.getDefault().getBeanByClass(ConditionTemplateDAO.class);
        ConstructorTreeProcessor processor = Activator.getDefault().getBeanByClass(ConstructorTreeProcessor.class, "treeProcessorImpl");
        DiscountConditionTemplateDialog dialog = new DiscountConditionTemplateDialog(parent, dao, processor);
        dialog.setTitle(title);
        if (dialog.open() == 0 && (condition = dialog.getDiscountCondition()) != null) {
            condition.setParent(parent);
            parent.addDiscountCondition(condition);
            log.trace("Added " + condition + " to " + parent);
        }
        return null;
    }
}

