/*
 * Decompiled with CFR 0.152.
 */
package su.artix.yuki.model.directory;

import java.util.Collection;
import ru.ssa.cashadmin.LibActivator;
import ru.ssa.cashadmin.dao.DaoFactory;
import ru.ssa.cashadmin.dao.DaoInterface;
import ru.ssa.cashadmin.domain.Invent;
import ru.ssa.cashadmin.domain.InventCatalog;
import ru.ssa.cashadmin.domain.InventPrice;
import ru.ssa.cashadmin.domain.InventSaleRestrict;
import ru.ssa.cashadmin.excep.ExecuteQueryException;
import su.artix.yuki.model.directory.DirectoryModel;

public class DirectoryInventModel
extends DirectoryModel<Invent> {
    public DirectoryInventModel() {
        super(Invent.class);
    }

    @Override
    protected void doAfterChangeId(Object oldId, Invent obj) throws ExecuteQueryException {
        DaoInterface dao = DaoFactory.getDAO(InventPrice.class);
        dao.changeIdNoExtractPK(oldId, (Object)obj.getBcode(), new String[]{"bcode"});
    }

    @Override
    public void delete(Invent obj) throws ExecuteQueryException {
        DaoInterface dao = DaoFactory.getDAO(Invent.class);
        this.removeInventPrices(obj);
        Invent state = (Invent)LibActivator.getDefault().getActualClassResolver().getInstance(Invent.class);
        state.setCode(obj.getCode());
        if (dao.count((Object)state) <= 1L) {
            this.removeInventSaleRestricts(obj);
            this.removeInventCatalogs(obj);
        }
        super.delete(obj);
    }

    private void removeInventCatalogs(Invent obj) throws ExecuteQueryException {
        InventCatalog state = (InventCatalog)LibActivator.getDefault().getActualClassResolver().getInstance(InventCatalog.class);
        state.setTmccode(obj.getCode());
        DaoInterface dao = DaoFactory.getDAO(InventCatalog.class);
        dao.deleteAll((Collection)dao.getList((Object)state));
    }

    private void removeInventSaleRestricts(Invent obj) throws ExecuteQueryException {
        InventSaleRestrict state = (InventSaleRestrict)LibActivator.getDefault().getActualClassResolver().getInstance(InventSaleRestrict.class);
        state.setTmccode(obj.getCode());
        DaoInterface dao = DaoFactory.getDAO(InventSaleRestrict.class);
        dao.deleteAll((Collection)dao.getList((Object)state));
    }

    private void removeInventPrices(Invent obj) throws ExecuteQueryException {
        DaoInterface dao = DaoFactory.getDAO(InventPrice.class);
        InventPrice state = (InventPrice)LibActivator.getDefault().getActualClassResolver().getInstance(LibActivator.getDefault().getActualClassResolver().getActual(InventPrice.class));
        state.setBcode(obj.getBcode());
        dao.deleteAll((Collection)dao.getList((Object)state));
    }
}

